/*
 * Decompiled with CFR 0.152.
 */
package hanziinput;

import hanzilookup.HanziLookup;
import hanzilookup.ui.HanziLookupUIBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import kiang.chinese.font.ChineseFontFinder;

public class HanziInput
extends JApplet
implements HanziLookup.CharacterSelectionListener {
    private static final String DATA_PATH = "/strokes.dat";
    private HanziLookup lookupPanel;
    private JTextArea textArea;

    public void init() {
        Font font = ChineseFontFinder.getChineseFont();
        this.lookupPanel = this.buildLookupPanel(font);
        if (null != font) {
            boolean bl = ChineseFontFinder.isSimplifiedFont(font);
            boolean bl2 = ChineseFontFinder.isTraditionalFont(font);
            if (bl && !bl2) {
                this.lookupPanel.setSearchType(1);
            } else if (bl2 && !bl) {
                this.lookupPanel.setSearchType(2);
            }
        }
        this.textArea = this.buildTextArea(font);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.lookupPanel, "West");
        container.add((Component)jScrollPane, "Center");
        ArrayList<JTextArea> arrayList = new ArrayList<JTextArea>();
        arrayList.add(this.textArea);
        this.setJMenuBar(this.buildMenuBar(arrayList));
    }

    private HanziLookup buildLookupPanel(Font font) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(DATA_PATH);
            HanziLookup hanziLookup = new HanziLookup(inputStream, font);
            hanziLookup.addCharacterReceiver(this);
            return hanziLookup;
        }
        catch (IOException iOException) {
            System.err.println("Error reading in strokes data!");
            iOException.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private JTextArea buildTextArea(Font font) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(font);
        jTextArea.setColumns(30);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    private JMenuBar buildMenuBar(Collection collection) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = HanziLookupUIBuilder.buildOptionsMenu(this.lookupPanel, collection);
        JMenu jMenu2 = this.buildEditMenu();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    private JMenu buildEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        jMenuItem.setText("Cut");
        jMenuItem.setMnemonic(84);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem2.setText("Copy");
        jMenuItem2.setMnemonic(67);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(new DefaultEditorKit.PasteAction());
        jMenuItem3.setText("Paste");
        jMenuItem3.setMnemonic(80);
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    public void characterSelected(HanziLookup.CharacterSelectionEvent characterSelectionEvent) {
        try {
            int n = this.textArea.getCaretPosition();
            this.textArea.getDocument().insertString(n, Character.toString(characterSelectionEvent.getSelectedCharacter()), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        HanziInput hanziInput = new HanziInput();
        hanziInput.init();
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(hanziInput);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

