/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup;

import hanzilookup.data.CharacterDescriptor;
import hanzilookup.data.MemoryStrokesStreamProvider;
import hanzilookup.data.ResourceStrokesStreamProvider;
import hanzilookup.data.StrokesDataSource;
import hanzilookup.data.StrokesMatcher;
import hanzilookup.data.StrokesParser;
import hanzilookup.ui.CharacterCanvas;
import hanzilookup.ui.WrittenCharacter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import kiang.swing.JClickableList;

public class HanziLookup
extends JPanel
implements CharacterCanvas.StrokesListener,
StrokesMatcher.ResultsHandler {
    private int searchType;
    private CharacterCanvas inputCanvas;
    private JButton lookupButton;
    private JButton clearButton;
    private JButton undoButton;
    private KeyStroke lookupMacro;
    private KeyStroke clearMacro;
    private KeyStroke undoMacro;
    private JList candidatesList;
    private StrokesDataSource strokesDataSource;
    private boolean autoLookup = true;
    private double looseness = 0.25;
    private int numResults = 15;
    private StrokesMatcher currentMatcher;
    private Set characterHandlers = new LinkedHashSet();
    private static final Dimension CANVAS_DIMENSION = new Dimension(235, 235);
    private static final Dimension SELECTION_DIMENSION = new Dimension(275, 130);

    public HanziLookup(InputStream inputStream, InputStream inputStream2, Font font) throws IOException {
        StrokesParser strokesParser = new StrokesParser(inputStream, inputStream2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        strokesParser.writeCompiledOutput(byteArrayOutputStream);
        this.strokesDataSource = new StrokesDataSource(new MemoryStrokesStreamProvider(byteArrayOutputStream.toByteArray()));
        this.initUI(font);
    }

    public HanziLookup(InputStream inputStream, Font font) throws IOException {
        this.strokesDataSource = new StrokesDataSource(new MemoryStrokesStreamProvider(inputStream));
        this.initUI(font);
    }

    public HanziLookup(String string, Font font) throws IOException {
        this.strokesDataSource = new StrokesDataSource(new ResourceStrokesStreamProvider(string));
        this.initUI(font);
    }

    private void initUI(Font font) {
        JPanel jPanel = this.buildInputPanel();
        JPanel jPanel2 = this.buildSelectionPanel();
        this.setFont(font);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(76, 8);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 8);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(90, 2);
        this.registerLookupMacro(keyStroke);
        this.registerClearMacro(keyStroke2);
        this.registerUndoMacro(keyStroke3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterReceiver(CharacterSelectionListener characterSelectionListener) {
        Set set = this.characterHandlers;
        synchronized (set) {
            this.characterHandlers.add(characterSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterReceiver(CharacterSelectionListener characterSelectionListener) {
        Set set = this.characterHandlers;
        synchronized (set) {
            this.characterHandlers.remove(characterSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReceivers(char c) {
        Set set = this.characterHandlers;
        synchronized (set) {
            Iterator iterator = this.characterHandlers.iterator();
            while (iterator.hasNext()) {
                CharacterSelectionListener characterSelectionListener = (CharacterSelectionListener)iterator.next();
                characterSelectionListener.characterSelected(new CharacterSelectionEvent(this, c));
            }
        }
    }

    void runLookup() {
        this.candidatesList.setModel(new DefaultListModel());
        WrittenCharacter writtenCharacter = this.inputCanvas.getCharacter();
        if (writtenCharacter.getStrokeList().size() == 0) {
            this.handleResults(new Character[0]);
        }
        CharacterDescriptor characterDescriptor = writtenCharacter.buildCharacterDescriptor();
        if (this.currentMatcher != null) {
            this.currentMatcher.stop();
        }
        boolean bl = this.searchType == 0 || this.searchType == 2;
        boolean bl2 = this.searchType == 0 || this.searchType == 1;
        this.currentMatcher = new StrokesMatcher(this, characterDescriptor, bl, bl2, this.looseness, this.numResults, this.strokesDataSource);
        Thread thread = new Thread(this.currentMatcher);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResults(Character[] characterArray) {
        JList jList = this.candidatesList;
        synchronized (jList) {
            this.candidatesList.setListData(characterArray);
            this.lookupButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.inputCanvas.clear();
        this.inputCanvas.repaint();
        JList jList = this.candidatesList;
        synchronized (jList) {
            this.candidatesList.setListData(new Object[0]);
            this.candidatesList.repaint();
        }
    }

    private void undo() {
        this.inputCanvas.undo();
        if (this.autoLookup) {
            this.runLookup();
        }
        this.inputCanvas.repaint();
    }

    private void lookup() {
        this.lookupButton.setEnabled(false);
        this.runLookup();
    }

    private JPanel buildInputPanel() {
        this.inputCanvas = new CharacterCanvas();
        this.inputCanvas.setPreferredSize(CANVAS_DIMENSION);
        this.inputCanvas.addStrokesListener(this);
        JPanel jPanel = this.buildCanvasButtons();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.inputCanvas, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createTitledBorder("Enter character"));
        return jPanel2;
    }

    private JPanel buildCanvasButtons() {
        this.lookupButton = new JButton("Lookup");
        this.clearButton = new JButton("Clear");
        this.undoButton = new JButton("Undo");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == HanziLookup.this.lookupButton) {
                    HanziLookup.this.lookup();
                } else if (actionEvent.getSource() == HanziLookup.this.clearButton) {
                    HanziLookup.this.clear();
                } else if (actionEvent.getSource() == HanziLookup.this.undoButton) {
                    HanziLookup.this.undo();
                }
            }
        };
        this.lookupButton.addActionListener(actionListener);
        this.clearButton.addActionListener(actionListener);
        this.undoButton.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.lookupButton);
        jPanel.add(this.undoButton);
        jPanel.add(this.clearButton);
        return jPanel;
    }

    private JPanel buildSelectionPanel() {
        this.candidatesList = this.buildCandidatesList();
        JScrollPane jScrollPane = new JScrollPane(this.candidatesList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setPreferredSize(SELECTION_DIMENSION);
        jPanel.setBorder(BorderFactory.createTitledBorder("Select character"));
        return jPanel;
    }

    private JList buildCandidatesList() {
        final JClickableList jClickableList = new JClickableList();
        jClickableList.setSelectionMode(0);
        jClickableList.setLayoutOrientation(2);
        jClickableList.setVisibleRowCount(-1);
        ((DefaultListCellRenderer)jClickableList.getCellRenderer()).setHorizontalAlignment(0);
        jClickableList.addListClickedListener(new JClickableList.ListClickedListener(){

            public void listClicked(JClickableList.ListClickedEvent listClickedEvent) {
                Character c = (Character)jClickableList.getSelectedValue();
                if (null != c) {
                    HanziLookup.this.notifyReceivers(c.charValue());
                }
            }
        });
        return jClickableList;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (null != font && null != this.candidatesList) {
            this.candidatesList.setFont(font);
            this.resetListCellWidth(font);
        }
    }

    protected void validateTree() {
        super.validateTree();
        this.resetListCellWidth(this.candidatesList.getFont());
    }

    private void resetListCellWidth(Font font) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = this.candidatesList.getWidth();
        n = n == 0 ? (int)this.candidatesList.getPreferredSize().getWidth() : n;
        int n2 = 2 * fontMetrics.charWidth('\u4e00');
        this.candidatesList.setFixedCellWidth(n2);
    }

    public void setSearchType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("searchType invalid!");
        }
        int n2 = this.searchType;
        this.searchType = n;
        if (this.autoLookup && n2 != n) {
            this.runLookup();
        }
    }

    public int getSearchType() {
        return this.searchType;
    }

    public void setNumResults(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("numResults must be at least 1!");
        }
        this.numResults = n;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setAutoLookup(boolean bl) {
        this.autoLookup = bl;
    }

    public boolean getAutoLookup() {
        return this.autoLookup;
    }

    public void setLooseness(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("looseness must be between 0.0 and 1.0!");
        }
        this.looseness = d;
    }

    public double getLooseness() {
        return this.looseness;
    }

    public void strokeFinished(CharacterCanvas.StrokeEvent strokeEvent) {
        if (this.autoLookup) {
            this.runLookup();
        }
    }

    public KeyStroke getLookupMacro() {
        return this.lookupMacro;
    }

    public KeyStroke getUndoMacro() {
        return this.undoMacro;
    }

    public KeyStroke getClearMacro() {
        return this.clearMacro;
    }

    public void registerLookupMacro(KeyStroke keyStroke) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HanziLookup.this.lookupButton.doClick();
            }
        };
        this.registerMacro(keyStroke, this.lookupMacro, "hanzilookup.lookup", abstractAction);
        this.lookupMacro = keyStroke;
    }

    public void registerClearMacro(KeyStroke keyStroke) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HanziLookup.this.clearButton.doClick();
            }
        };
        this.registerMacro(keyStroke, this.clearMacro, "hanzilookup.clear", abstractAction);
        this.clearMacro = keyStroke;
    }

    public void registerUndoMacro(KeyStroke keyStroke) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HanziLookup.this.undoButton.doClick();
            }
        };
        this.registerMacro(keyStroke, this.undoMacro, "hanzilookup.undo", abstractAction);
        this.undoMacro = keyStroke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMacro(KeyStroke keyStroke, KeyStroke keyStroke2, String string, Action action) {
        InputMap inputMap = this.getInputMap(2);
        Serializable serializable = inputMap;
        synchronized (serializable) {
            if (null != keyStroke2) {
                inputMap.remove(keyStroke2);
            }
            inputMap.put(keyStroke, string);
        }
        Serializable serializable2 = serializable = this.getActionMap();
        synchronized (serializable2) {
            ((ActionMap)serializable).put(string, action);
        }
    }

    public static class CharacterSelectionEvent
    extends EventObject {
        private char character;

        private CharacterSelectionEvent(Object object, char c) {
            super(object);
            this.character = c;
        }

        public char getSelectedCharacter() {
            return this.character;
        }
    }

    public static interface CharacterSelectionListener {
        public void characterSelected(CharacterSelectionEvent var1);
    }
}

