/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.data;

import java.util.Map;

public class CharacterTypeRepository {
    public static final int GENERIC_TYPE = 0;
    public static final int SIMPLIFIED_TYPE = 1;
    public static final int TRADITIONAL_TYPE = 2;
    public static final int EQUIVALENT_TYPE = 3;
    public static final int NOT_FOUND = -1;
    private Map typeMap;

    public CharacterTypeRepository(Map map) {
        this.typeMap = map;
    }

    public TypeDescriptor lookup(Character c) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)this.typeMap.get(c);
        return typeDescriptor;
    }

    public int getType(Character c) {
        TypeDescriptor typeDescriptor = this.lookup(c);
        if (null != typeDescriptor) {
            if (typeDescriptor.type == 0 || typeDescriptor.type == 1 || typeDescriptor.type == 2) {
                return typeDescriptor.type;
            }
            if (typeDescriptor.type == 3) {
                return this.getType(typeDescriptor.altUnicode);
            }
        }
        return -1;
    }

    public static class TypeDescriptor {
        private int type;
        private Character unicode;
        private Character altUnicode;

        public TypeDescriptor(int n, Character c, Character c2) {
            this.type = n;
            this.unicode = c;
            this.altUnicode = c2;
        }

        public int getType() {
            return this.type;
        }

        public Character getUnicode() {
            return this.unicode;
        }

        public Character getAlUnicode() {
            return this.altUnicode;
        }
    }
}

