/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.data;

import hanzilookup.data.CharacterDescriptor;
import hanzilookup.data.StrokesIO;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class StrokesDataSource {
    private StrokesStreamProvider streamProvider;
    private long[] genericPositions = new long[48];
    private long[] simplifiedPositions = new long[48];
    private long[] traditionalPositions = new long[48];

    public StrokesDataSource(StrokesStreamProvider strokesStreamProvider) throws IOException {
        this.streamProvider = strokesStreamProvider;
        this.indexPositions();
    }

    private void indexPositions() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.streamProvider.getStrokesStream());
        long l = 0L;
        l = this.loadPositions(this.genericPositions, dataInputStream, l);
        l = this.loadPositions(this.simplifiedPositions, dataInputStream, l);
        l = this.loadPositions(this.traditionalPositions, dataInputStream, l);
        dataInputStream.close();
    }

    private long loadPositions(long[] lArray, DataInputStream dataInputStream, long l) throws IOException {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = l;
            int n = dataInputStream.readInt();
            l += (long)(n + 4);
            StrokesDataSource.skipFully(n, dataInputStream);
        }
        return l;
    }

    public StrokesDataScanner getStrokesScanner(boolean bl, boolean bl2, int n, int n2) {
        n = Math.max(1, n);
        n2 = Math.min(48, n2);
        return new StrokesDataScanner(bl, bl2, n, n2);
    }

    private static void skipFully(long l, DataInputStream dataInputStream) throws IOException {
        while (l > 0L) {
            l -= dataInputStream.skip(l);
        }
    }

    public static interface StrokesStreamProvider {
        public InputStream getStrokesStream();
    }

    public class StrokesDataScanner {
        private DataInputStream strokeDataStream;
        private Iterator positionsIter;
        private long position;
        private long endOfStrokeCount;
        private boolean skipToNextTypePosition;
        private boolean loadNextStrokeCount;
        private int strokeCount;
        private int minStrokes;
        private int maxStrokes;

        private StrokesDataScanner(boolean bl, boolean bl2, int n, int n2) {
            int n3 = n - 1;
            ArrayList<Long> arrayList = new ArrayList<Long>(3);
            arrayList.add(new Long(StrokesDataSource.this.genericPositions[n3]));
            if (bl2) {
                arrayList.add(new Long(StrokesDataSource.this.simplifiedPositions[n3]));
            }
            if (bl) {
                arrayList.add(new Long(StrokesDataSource.this.traditionalPositions[n3]));
            }
            this.strokeDataStream = new DataInputStream(StrokesDataSource.this.streamProvider.getStrokesStream());
            this.positionsIter = arrayList.iterator();
            this.position = 0L;
            this.skipToNextTypePosition = true;
            this.loadNextStrokeCount = true;
            this.strokeCount = n;
            this.minStrokes = n;
            this.maxStrokes = n2;
        }

        public boolean loadNextCharacterStrokeData(CharacterDescriptor characterDescriptor) throws IOException {
            if (null == this.strokeDataStream) {
                return false;
            }
            if (this.skipToNextTypePosition) {
                if (!this.positionsIter.hasNext()) {
                    return false;
                }
                long l = (Long)this.positionsIter.next();
                long l2 = l - this.position;
                StrokesDataSource.skipFully(l2, this.strokeDataStream);
                this.position = l;
                this.skipToNextTypePosition = false;
            }
            if (this.loadNextStrokeCount) {
                this.position += 4L;
                this.endOfStrokeCount = this.position + (long)this.strokeDataStream.readInt();
                this.loadNextStrokeCount = false;
            }
            if (this.position < this.endOfStrokeCount) {
                this.loadNextCharacterDataFromStream(characterDescriptor, this.strokeDataStream);
                this.position += (long)(4 + characterDescriptor.getStrokeCount() + 4 * characterDescriptor.getSubStrokeCount());
            }
            if (this.position == this.endOfStrokeCount) {
                this.loadNextStrokeCount = true;
                if (this.strokeCount == this.maxStrokes) {
                    this.skipToNextTypePosition = true;
                    this.strokeCount = this.minStrokes;
                } else {
                    ++this.strokeCount;
                }
            }
            return true;
        }

        private void loadNextCharacterDataFromStream(CharacterDescriptor characterDescriptor, DataInputStream dataInputStream) throws IOException {
            Character c = new Character(StrokesIO.readCharacter(dataInputStream));
            int n = StrokesIO.readCharacterType(dataInputStream);
            int n2 = StrokesIO.readStrokeCount(dataInputStream);
            int n3 = 0;
            double[] dArray = characterDescriptor.getDirections();
            double[] dArray2 = characterDescriptor.getLengths();
            for (int i = 0; i < n2; ++i) {
                int n4 = StrokesIO.readSubStrokeCount(dataInputStream);
                for (int j = 0; j < n4; ++j) {
                    double d = StrokesIO.readDirection(dataInputStream);
                    double d2 = StrokesIO.readLength(dataInputStream);
                    dArray[n3] = d;
                    dArray2[n3] = d2;
                    ++n3;
                }
            }
            characterDescriptor.setCharacter(c);
            characterDescriptor.setCharacterType(n);
            characterDescriptor.setStrokeCount(n2);
            characterDescriptor.setSubStrokeCount(n3);
        }
    }
}

