/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StrokesIO {
    public static void writeCharacter(char c, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeChar(c);
    }

    public static char readCharacter(DataInputStream dataInputStream) throws IOException {
        char c = dataInputStream.readChar();
        return c;
    }

    public static void writeCharacterType(int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(n);
    }

    public static int readCharacterType(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by;
    }

    public static void writeStrokeCount(int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(n);
    }

    public static int readStrokeCount(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by;
    }

    public static void writeSubStrokeCount(int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(n);
    }

    public static int readSubStrokeCount(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by;
    }

    public static void writeDirection(double d, DataOutputStream dataOutputStream) throws IOException {
        short s = StrokesIO.convertDirectionToShort(d);
        dataOutputStream.writeShort(s);
    }

    public static double readDirection(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        double d = StrokesIO.convertDirectionFromShort(s);
        return d;
    }

    public static void writeLength(double d, DataOutputStream dataOutputStream) throws IOException {
        short s = StrokesIO.convertLengthToShort(d);
        dataOutputStream.writeShort(s);
    }

    public static double readLength(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        double d = StrokesIO.convertLengthFromShort(s);
        return d;
    }

    private static double convertDirectionFromShort(short s) {
        double d = ((double)s + 32767.0) / 32767.0;
        double d2 = d * 2.0 * Math.PI;
        return d2;
    }

    private static double convertLengthFromShort(double d) {
        double d2 = (d + 32767.0) / 32767.0;
        return d2;
    }

    private static short convertDirectionToShort(double d) {
        double d2 = d / (Math.PI * 2);
        short s = (short)(d2 * 32767.0 - 32767.0);
        return s;
    }

    private static short convertLengthToShort(double d) {
        short s = (short)(d * 32767.0 - 32767.0);
        return s;
    }
}

