/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.data;

import hanzilookup.data.CharacterDescriptor;
import hanzilookup.data.StrokesDataSource;
import java.awt.geom.CubicCurve2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kiang.awt.geom.CurveUtils;
import kiang.util.PriorityList;

public class StrokesMatcher
implements Runnable {
    private CharacterDescriptor inputCharacter;
    private CharacterDescriptor compareTo;
    private double[][] scoreMatrix;
    private boolean searchTraditional;
    private boolean searchSimplified;
    private double looseness;
    private CharacterMatchCollector matches;
    private boolean running;
    private ResultsHandler resultsHandler;
    private StrokesDataSource strokesDataSource;
    static final double CORRECT_NUM_STROKES_BONUS = 0.1;
    static final int CORRECT_NUM_STROKES_CAP = 10;
    private static final double SKIP_PENALTY_MULTIPLIER = 1.75;
    private static final double[] DIRECTION_SCORE_TABLE = StrokesMatcher.initDirectionScoreTable();
    private static final double[] LENGTH_SCORE_TABLE = StrokesMatcher.initLengthScoreTable();

    public StrokesMatcher(ResultsHandler resultsHandler, CharacterDescriptor characterDescriptor, boolean bl, boolean bl2, double d, int n, StrokesDataSource strokesDataSource) {
        this.inputCharacter = characterDescriptor;
        this.compareTo = new CharacterDescriptor();
        this.searchTraditional = bl;
        this.searchSimplified = bl2;
        this.looseness = d;
        this.running = true;
        this.strokesDataSource = strokesDataSource;
        this.resultsHandler = resultsHandler;
        this.matches = new CharacterMatchCollector(n);
        this.initScoreMatrix();
    }

    public void run() {
        Character[] characterArray = this.doMatching();
        if (null != characterArray) {
            this.resultsHandler.handleResults(characterArray);
        }
    }

    private Character[] doMatching() {
        Character[] characterArray;
        int n = this.inputCharacter.getStrokeCount();
        int n2 = this.inputCharacter.getSubStrokeCount();
        int n3 = this.getStrokesRange(n, this.looseness);
        int n4 = Math.max(n - n3, 1);
        int n5 = Math.min(n + n3, 48);
        int n6 = this.getSubStrokesRange(n2, this.looseness);
        StrokesDataSource.StrokesDataScanner strokesDataScanner = this.strokesDataSource.getStrokesScanner(this.searchTraditional, this.searchSimplified, n4, n5);
        try {
            while (strokesDataScanner.loadNextCharacterStrokeData(this.compareTo)) {
                characterArray = this.compareToNext(n, n2, n6);
                this.matches.addMatch((CharacterMatch)characterArray);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error running strokes comparison!");
            iOException.printStackTrace();
        }
        characterArray = this.matches.getMatches();
        if (this.isRunning()) {
            return characterArray;
        }
        return null;
    }

    private int getStrokesRange(int n, double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d == 1.0) {
            return 48;
        }
        double d2 = 0.35;
        double d3 = (double)n * 0.4;
        double d4 = 0.6;
        double d5 = n;
        double[] dArray = new double[1];
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(0.0, 0.0, d2, d3, d4, d5, 1.0, 48.0);
        CurveUtils.solveCubicCurveForX(double_, d, dArray);
        double d6 = dArray[0];
        return (int)Math.round(CurveUtils.getPointOnCubicCurve(double_, d6).getY());
    }

    private int getSubStrokesRange(int n, double d) {
        if (d == 1.0) {
            return 64;
        }
        double d2 = (double)n * 0.25;
        double d3 = 0.4;
        double d4 = 1.5 * d2;
        double d5 = 0.75;
        double d6 = 1.5 * d4;
        double[] dArray = new double[1];
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(0.0, d2, d3, d4, d5, d6, 1.0, 64.0);
        CurveUtils.solveCubicCurveForX(double_, d, dArray);
        double d7 = dArray[0];
        return (int)Math.round(CurveUtils.getPointOnCubicCurve(double_, d7).getY());
    }

    private void initScoreMatrix() {
        int n = 65;
        this.scoreMatrix = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double d;
            this.scoreMatrix[i][0] = d = -0.5775 * (double)i;
            this.scoreMatrix[0][i] = d;
        }
    }

    private CharacterMatch compareToNext(int n, int n2, int n3) {
        Character c = this.compareTo.getCharacter();
        int n4 = this.compareTo.getCharacterType();
        int n5 = this.compareTo.getStrokeCount();
        int n6 = this.compareTo.getSubStrokeCount();
        double d = this.computeMatchScore(n2, n6, n3);
        if (n == n5 && n < 10) {
            double d2 = 0.1 * ((double)Math.max(10 - n, 0) / 10.0);
            d += d2 * d;
        }
        return new CharacterMatch(c, d);
    }

    private double computeMatchScore(int n, int n2, int n3) {
        double[] dArray = this.inputCharacter.getDirections();
        double[] dArray2 = this.inputCharacter.getLengths();
        double[] dArray3 = this.compareTo.getDirections();
        double[] dArray4 = this.compareTo.getLengths();
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                double d3 = Double.MIN_VALUE;
                if (Math.abs(i - j) <= n3) {
                    double d4 = dArray3[j];
                    double d5 = dArray4[j];
                    double d6 = this.scoreMatrix[i][j + 1] - d2 * 1.75;
                    double d7 = this.scoreMatrix[i + 1][j] - d5 * 1.75;
                    double d8 = Math.max(d6, d7);
                    double d9 = this.computeSubStrokeScore(d, d2, d4, d5);
                    double d10 = this.scoreMatrix[i][j];
                    d3 = Math.max(d10 + d9, d8);
                }
                this.scoreMatrix[i + 1][j + 1] = d3;
            }
        }
        return this.scoreMatrix[n][n2];
    }

    private double computeSubStrokeScore(double d, double d2, double d3, double d4) {
        double d5 = this.getDirectionScore(d, d3, d2);
        double d6 = this.getLengthScore(d2, d4);
        double d7 = d6 * d5;
        return d7;
    }

    private static double[] initDirectionScoreTable() {
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(0.0, 1.0, 0.5, 1.0, 0.25, -2.0, 1.0, 1.0);
        return StrokesMatcher.initCubicCurveScoreTable(double_, 100);
    }

    private static double[] initLengthScoreTable() {
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(0.0, 0.0, 0.25, 1.0, 0.75, 1.0, 1.0, 1.0);
        return StrokesMatcher.initCubicCurveScoreTable(double_, 100);
    }

    private static double[] initCubicCurveScoreTable(CubicCurve2D cubicCurve2D, int n) {
        double d = cubicCurve2D.getX1();
        double d2 = cubicCurve2D.getX2();
        double d3 = d2 - d;
        double d4 = d;
        double d5 = d3 / (double)n;
        double[] dArray = new double[n];
        double[] dArray2 = new double[1];
        for (int i = 0; i < n; ++i) {
            CurveUtils.solveCubicCurveForX(cubicCurve2D, Math.min(d4, d2), dArray2);
            double d6 = dArray2[0];
            dArray[i] = CurveUtils.getPointOnCubicCurve(cubicCurve2D, d6).getY();
            d4 += d5;
        }
        return dArray;
    }

    private double getDirectionScore(double d, double d2, double d3) {
        int n;
        double d4;
        double d5;
        double d6;
        double d7 = Math.abs(d - d2);
        if (d7 > Math.PI) {
            d7 = Math.PI * 2 - d7;
        }
        if ((d6 = (d5 = Math.min(1.0, 1.0 - (d4 = DIRECTION_SCORE_TABLE[n = (int)(d7 / Math.PI * (double)(DIRECTION_SCORE_TABLE.length - 1))]))) * (-4.0 * d3 + 1.0)) > 0.0) {
            d4 += d6;
        }
        return d4;
    }

    private double getLengthScore(double d, double d2) {
        double d3 = d < d2 ? d / d2 : d2 / d;
        int n = (int)(d3 * (double)(LENGTH_SCORE_TABLE.length - 1));
        double d4 = LENGTH_SCORE_TABLE[n];
        return d4;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() {
        this.running = false;
    }

    private static class CharacterMatchCollector {
        private Map matchMap = new HashMap();
        private PriorityList matches = new PriorityList();
        private int maxSize;

        private CharacterMatchCollector(int n) {
            this.maxSize = n;
        }

        private boolean addMatch(CharacterMatch characterMatch) {
            CharacterMatch characterMatch2 = (CharacterMatch)this.matchMap.get(characterMatch.character);
            if (null != characterMatch2) {
                if (characterMatch.score > characterMatch2.score) {
                    this.matches.remove(characterMatch2);
                } else {
                    return false;
                }
            }
            if (this.matches.size() >= this.maxSize) {
                CharacterMatch characterMatch3 = (CharacterMatch)this.matches.getLast();
                if (characterMatch.score > characterMatch3.score) {
                    this.matches.removeLast();
                    this.matchMap.remove(characterMatch3.character);
                } else {
                    return false;
                }
            }
            this.matchMap.put(characterMatch.character, characterMatch);
            this.matches.add(characterMatch);
            return true;
        }

        private Character[] getMatches() {
            Character[] characterArray = new Character[this.matches.size()];
            Iterator iterator = this.matches.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                CharacterMatch characterMatch = (CharacterMatch)iterator.next();
                characterArray[n] = characterMatch.character;
                ++n;
            }
            return characterArray;
        }
    }

    public static interface ResultsHandler {
        public void handleResults(Character[] var1);
    }

    private static class CharacterMatch
    implements Comparable {
        private Character character;
        private double score;

        public CharacterMatch(Character c, double d) {
            this.character = c;
            this.score = d;
        }

        public int compareTo(Object object) {
            CharacterMatch characterMatch = (CharacterMatch)object;
            double d = this.score;
            double d2 = characterMatch.score;
            if (d < d2) {
                return 1;
            }
            if (d > d2) {
                return -1;
            }
            return 0;
        }
    }
}

