/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.data;

import hanzilookup.data.CharacterTypeParser;
import hanzilookup.data.CharacterTypeRepository;
import hanzilookup.data.StrokesIO;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kiang.io.LineParser;

public class StrokesParser
extends LineParser {
    private ByteArrayOutputStream[] genericByteStreams;
    private ByteArrayOutputStream[] simplifiedByteStreams;
    private ByteArrayOutputStream[] traditionalByteStreams;
    private DataOutputStream[] genericOutStreams;
    private DataOutputStream[] simplifiedOutStreams;
    private DataOutputStream[] traditionalOutStreams;
    private CharacterTypeRepository typeRepository;
    private int[] subStrokesPerStroke = new int[48];
    private double[] subStrokeDirections = new double[64];
    private double[] subStrokeLengths = new double[64];
    private Pattern linePattern = Pattern.compile("^([a-fA-F0-9]{4})\\s*\\|(.*)$");
    private Pattern subStrokePattern = Pattern.compile("^\\s*\\((\\d+(\\.\\d{1,10})?)\\s*,\\s*(\\d+(\\.\\d{1,10})?)\\)\\s*$");

    public StrokesParser(InputStream inputStream, CharacterTypeRepository characterTypeRepository) throws IOException {
        this.typeRepository = characterTypeRepository;
        this.initStrokes(inputStream);
    }

    public StrokesParser(InputStream inputStream, InputStream inputStream2) throws IOException {
        CharacterTypeParser characterTypeParser = new CharacterTypeParser(inputStream2);
        this.typeRepository = characterTypeParser.buildCharacterTypeRepository();
        this.initStrokes(inputStream);
    }

    private void initStrokes(InputStream inputStream) throws IOException {
        try {
            this.prepareStrokeBytes();
            this.parse(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Error reading character stroke data!");
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public void writeCompiledOutput(OutputStream outputStream) throws IOException {
        byte[][] byArrayArray = new byte[48][];
        byte[][] byArrayArray2 = new byte[48][];
        byte[][] byArrayArray3 = new byte[48][];
        for (int i = 0; i < 48; ++i) {
            byArrayArray[i] = this.genericByteStreams[i].toByteArray();
            byArrayArray2[i] = this.simplifiedByteStreams[i].toByteArray();
            byArrayArray3[i] = this.traditionalByteStreams[i].toByteArray();
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.writeStrokes(byArrayArray, dataOutputStream);
        this.writeStrokes(byArrayArray2, dataOutputStream);
        this.writeStrokes(byArrayArray3, dataOutputStream);
        dataOutputStream.close();
    }

    private void writeStrokes(byte[][] byArray, DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < 48; ++i) {
            int n = byArray[i].length;
            dataOutputStream.writeInt(n);
            dataOutputStream.write(byArray[i]);
        }
    }

    private void prepareStrokeBytes() {
        this.genericByteStreams = new ByteArrayOutputStream[48];
        this.genericOutStreams = new DataOutputStream[48];
        this.simplifiedByteStreams = new ByteArrayOutputStream[48];
        this.simplifiedOutStreams = new DataOutputStream[48];
        this.traditionalByteStreams = new ByteArrayOutputStream[48];
        this.traditionalOutStreams = new DataOutputStream[48];
        for (int i = 0; i < 48; ++i) {
            this.genericByteStreams[i] = new ByteArrayOutputStream();
            this.genericOutStreams[i] = new DataOutputStream(this.genericByteStreams[i]);
            this.simplifiedByteStreams[i] = new ByteArrayOutputStream();
            this.simplifiedOutStreams[i] = new DataOutputStream(this.simplifiedByteStreams[i]);
            this.traditionalByteStreams[i] = new ByteArrayOutputStream();
            this.traditionalOutStreams[i] = new DataOutputStream(this.traditionalByteStreams[i]);
        }
    }

    protected boolean parseLine(int n, String string) {
        Matcher matcher = this.linePattern.matcher(string);
        boolean bl = true;
        int n2 = 0;
        if (matcher.matches()) {
            Object object;
            String string2 = matcher.group(1);
            Character c = new Character((char)Integer.parseInt(string2, 16));
            String string3 = matcher.group(2);
            int n3 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (n3 >= 48) {
                    bl = false;
                    break;
                }
                object = stringTokenizer.nextToken();
                int n4 = this.parseStroke((String)object, n3, n2);
                if (n4 > 0) {
                    n2 += n4;
                } else {
                    bl = false;
                }
                ++n3;
            }
            if (bl) {
                int n5 = this.typeRepository.getType(c);
                if (n5 == -1) {
                    n5 = 0;
                }
                object = n5 == 2 ? this.traditionalOutStreams[n3 - 1] : (n5 == 1 ? this.simplifiedOutStreams[n3 - 1] : this.genericOutStreams[n3 - 1]);
                this.writeStrokeData((DataOutputStream)object, c, n5, n3, n2);
                return true;
            }
        }
        return false;
    }

    private int parseStroke(String string, int n, int n2) {
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        while (stringTokenizer.hasMoreTokens()) {
            if (n3 >= 64 || !this.parseSubStroke(stringTokenizer.nextToken(), n2 + n3)) {
                return -1;
            }
            ++n3;
        }
        this.subStrokesPerStroke[n] = n3;
        return n3;
    }

    private boolean parseSubStroke(String string, int n) {
        Matcher matcher = this.subStrokePattern.matcher(string);
        if (matcher.matches()) {
            double d = Double.parseDouble(matcher.group(1));
            double d2 = Double.parseDouble(matcher.group(3));
            this.subStrokeDirections[n] = d;
            this.subStrokeLengths[n] = d2;
            return true;
        }
        return false;
    }

    private void writeStrokeData(DataOutputStream dataOutputStream, Character c, int n, int n2, int n3) {
        try {
            StrokesIO.writeCharacter(c.charValue(), dataOutputStream);
            StrokesIO.writeCharacterType(n, dataOutputStream);
            StrokesIO.writeStrokeCount(n2, dataOutputStream);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5 = this.subStrokesPerStroke[i];
                StrokesIO.writeSubStrokeCount(n5, dataOutputStream);
                for (int j = 0; j < n5; ++j) {
                    StrokesIO.writeDirection(this.subStrokeDirections[n4], dataOutputStream);
                    StrokesIO.writeLength(this.subStrokeLengths[n4], dataOutputStream);
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Takes three arguments:\n");
            stringBuffer.append("1: the plain-text strokes data file\n");
            stringBuffer.append("2: the plain-text types data file\n");
            stringBuffer.append("3: the file to output the compiled data file to");
            System.err.println(stringBuffer);
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                FileInputStream fileInputStream2 = new FileInputStream(stringArray[1]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                CharacterTypeParser characterTypeParser = new CharacterTypeParser(fileInputStream2);
                CharacterTypeRepository characterTypeRepository = characterTypeParser.buildCharacterTypeRepository();
                StrokesParser strokesParser = new StrokesParser((InputStream)fileInputStream, characterTypeRepository);
                strokesParser.writeCompiledOutput(fileOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

