/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.ui;

import hanzilookup.ui.WrittenCharacter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class CharacterCanvas
extends JLabel
implements MouseInputListener {
    private WrittenCharacter inputCharacter = new WrittenCharacter();
    private WrittenCharacter.WrittenStroke currentStroke;
    private WrittenCharacter.WrittenPoint previousPoint;
    private Stroke paintStroke = new BasicStroke(3.0f, 1, 1);
    private Set strokesListeners = new LinkedHashSet();
    private static final double MIN_STROKE_SEGMENT_LENGTH = 5.0;

    public CharacterCanvas() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void clear() {
        this.inputCharacter.clear();
        this.currentStroke = null;
    }

    public void undo() {
        this.inputCharacter.undo();
    }

    public WrittenCharacter getCharacter() {
        return this.inputCharacter;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.getRoot(this).isFocusOwner()) {
            this.requestFocus();
        }
        WrittenCharacter writtenCharacter = this.inputCharacter;
        writtenCharacter.getClass();
        this.previousPoint = new WrittenCharacter.WrittenPoint(writtenCharacter, mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        WrittenCharacter writtenCharacter = this.inputCharacter;
        writtenCharacter.getClass();
        WrittenCharacter.WrittenPoint writtenPoint = new WrittenCharacter.WrittenPoint(writtenCharacter, mouseEvent.getX(), mouseEvent.getY());
        if (this.previousPoint.distance(writtenPoint) >= 5.0) {
            if (null == this.currentStroke) {
                this.currentStroke = new WrittenCharacter.WrittenStroke(this.inputCharacter);
                this.currentStroke.addPoint(this.previousPoint);
            }
            this.currentStroke.addPoint(writtenPoint);
            this.previousPoint = writtenPoint;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        if (null != this.currentStroke) {
            this.inputCharacter.addStroke(this.currentStroke);
            this.previousPoint = null;
            this.currentStroke = null;
            this.repaint();
        }
        this.notifyStrokesListeners();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.paintStroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (null != this.currentStroke) {
            this.paintStroke(this.currentStroke, graphics);
        }
        this.paintCharacter(graphics);
    }

    protected void paintCharacter(Graphics graphics) {
        List list = this.inputCharacter.getStrokeList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WrittenCharacter.WrittenStroke writtenStroke = (WrittenCharacter.WrittenStroke)iterator.next();
            this.paintStroke(writtenStroke, graphics);
        }
    }

    protected void paintStroke(WrittenCharacter.WrittenStroke writtenStroke, Graphics graphics) {
        graphics.setColor(Color.BLACK);
        Iterator iterator = writtenStroke.getPointList().iterator();
        WrittenCharacter.WrittenPoint writtenPoint = (WrittenCharacter.WrittenPoint)iterator.next();
        while (iterator.hasNext()) {
            WrittenCharacter.WrittenPoint writtenPoint2 = (WrittenCharacter.WrittenPoint)iterator.next();
            graphics.drawLine((int)writtenPoint.getX(), (int)writtenPoint.getY(), (int)writtenPoint2.getX(), (int)writtenPoint2.getY());
            writtenPoint = writtenPoint2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStrokesListener(StrokesListener strokesListener) {
        if (null != strokesListener) {
            Set set = this.strokesListeners;
            synchronized (set) {
                this.strokesListeners.add(strokesListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStrokesListener(StrokesListener strokesListener) {
        if (null != strokesListener) {
            Set set = this.strokesListeners;
            synchronized (set) {
                this.strokesListeners.remove(strokesListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStrokesListeners() {
        Set set = this.strokesListeners;
        synchronized (set) {
            Iterator iterator = this.strokesListeners.iterator();
            while (iterator.hasNext()) {
                StrokesListener strokesListener = (StrokesListener)iterator.next();
                strokesListener.strokeFinished(new StrokeEvent());
            }
        }
    }

    public class StrokeEvent
    extends EventObject {
        private StrokeEvent() {
            super(CharacterCanvas.this);
        }
    }

    public static interface StrokesListener {
        public void strokeFinished(StrokeEvent var1);
    }
}

