/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.ui;

import hanzilookup.HanziLookup;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kiang.chinese.font.ChineseFontChooserFactory;

public class HanziLookupUIBuilder {
    public static JMenu buildOptionsMenu(HanziLookup hanziLookup, Collection collection) {
        JMenu jMenu = new JMenu("Settings");
        JMenu jMenu2 = HanziLookupUIBuilder.buildCharacterModeMenu(hanziLookup);
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = HanziLookupUIBuilder.buildLookupOptionMenuItem(hanziLookup);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = HanziLookupUIBuilder.buildFontMenuItem(hanziLookup, collection);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    public static JMenu buildCharacterModeMenu(final HanziLookup hanziLookup) {
        int n = hanziLookup.getSearchType();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Simplified", 1 == n);
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Traditional", 2 == n);
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Both", 0 == n);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == jRadioButtonMenuItem) {
                    hanziLookup.setSearchType(1);
                } else if (object == jRadioButtonMenuItem2) {
                    hanziLookup.setSearchType(2);
                } else {
                    hanziLookup.setSearchType(0);
                }
            }
        };
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem2.addActionListener(actionListener);
        jRadioButtonMenuItem3.addActionListener(actionListener);
        JMenu jMenu = new JMenu("Character mode");
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        return jMenu;
    }

    public static JMenuItem buildLookupOptionMenuItem(final HanziLookup hanziLookup) {
        JMenuItem jMenuItem = new JMenuItem("Lookup options");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = HanziLookupUIBuilder.buildLookupOptionDialog(hanziLookup);
                jDialog.setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JMenuItem buildFontMenuItem(final HanziLookup hanziLookup, final Collection collection) {
        JMenuItem jMenuItem = new JMenuItem("Choose Font");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = ChineseFontChooserFactory.showDialog(hanziLookup);
                if (null != font) {
                    hanziLookup.setFont(font);
                    if (null != collection) {
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            Container container = (Container)iterator.next();
                            container.setFont(font);
                        }
                    }
                }
            }
        });
        return jMenuItem;
    }

    public static JDialog buildLookupOptionDialog(final HanziLookup hanziLookup) {
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Options");
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JCheckBox jCheckBox = HanziLookupUIBuilder.buildAutoLookupCheckBox(hanziLookup);
        jCheckBox.setAlignmentX(0.5f);
        container.add(jCheckBox);
        container.add(Box.createVerticalStrut(20));
        JLabel jLabel = new JLabel("Lookup Looseness");
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        JSlider jSlider = HanziLookupUIBuilder.buildLoosenessSlider(hanziLookup);
        jSlider.setAlignmentX(0.5f);
        container.add(jSlider);
        container.add(Box.createVerticalStrut(20));
        JLabel jLabel2 = new JLabel("Match Count");
        jLabel2.setAlignmentX(0.5f);
        container.add(jLabel2);
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(hanziLookup.getNumResults(), 1, 100, 1));
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner.getValue();
                hanziLookup.setNumResults(n);
            }
        });
        jSpinner.setMaximumSize(new Dimension(50, 25));
        container.add(jSpinner);
        container.add(Box.createVerticalStrut(20));
        KeyStroke keyStroke = hanziLookup.getLookupMacro();
        KeyStroke keyStroke2 = hanziLookup.getClearMacro();
        KeyStroke keyStroke3 = hanziLookup.getUndoMacro();
        String string = null != keyStroke ? HanziLookupUIBuilder.getKeyStrokeText(keyStroke.getKeyCode(), keyStroke.getModifiers()) : "(type macro)";
        String string2 = null != keyStroke2 ? HanziLookupUIBuilder.getKeyStrokeText(keyStroke2.getKeyCode(), keyStroke2.getModifiers()) : "(type macro)";
        String string3 = null != keyStroke3 ? HanziLookupUIBuilder.getKeyStrokeText(keyStroke3.getKeyCode(), keyStroke3.getModifiers()) : "(type macro)";
        JTextField jTextField = new JTextField(string, 10);
        JTextField jTextField2 = new JTextField(string2, 10);
        JTextField jTextField3 = new JTextField(string3, 10);
        MacroKeyListener macroKeyListener = new MacroKeyListener(jTextField, jTextField2, jTextField3, hanziLookup);
        jTextField.addKeyListener(macroKeyListener);
        jTextField2.addKeyListener(macroKeyListener);
        jTextField3.addKeyListener(macroKeyListener);
        JLabel jLabel3 = new JLabel("Lookup macro: ");
        JLabel jLabel4 = new JLabel("Clear macro: ");
        JLabel jLabel5 = new JLabel("Undo macro: ");
        jLabel3.setHorizontalAlignment(4);
        jLabel4.setHorizontalAlignment(4);
        jLabel5.setHorizontalAlignment(4);
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        jPanel.add(jLabel3);
        jPanel.add(jTextField);
        jPanel.add(jLabel4);
        jPanel.add(jTextField2);
        jPanel.add(jLabel5);
        jPanel.add(jTextField3);
        container.add(jPanel);
        container.add(Box.createVerticalStrut(20));
        JButton jButton = new JButton("OK");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        container.add(jButton);
        jDialog.pack();
        Point point = hanziLookup.getLocationOnScreen();
        int n = (int)(point.getX() + (double)(hanziLookup.getWidth() / 2) - (double)(jDialog.getWidth() / 2));
        int n2 = (int)(point.getY() + (double)(hanziLookup.getHeight() / 2) - (double)(jDialog.getHeight() / 2));
        jDialog.setLocation(n, n2);
        return jDialog;
    }

    private static String getKeyStrokeText(int n, int n2) {
        String string = n2 != 0 ? KeyEvent.getKeyModifiersText(n2) + " " : "";
        string = string + KeyEvent.getKeyText(n);
        return string;
    }

    public static JCheckBox buildAutoLookupCheckBox(final HanziLookup hanziLookup) {
        final JCheckBox jCheckBox = new JCheckBox("Auto Lookup", hanziLookup.getAutoLookup());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                hanziLookup.setAutoLookup(jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public static JSlider buildLoosenessSlider(final HanziLookup hanziLookup) {
        final JSlider jSlider = new JSlider(0, 20);
        int n = (int)((double)jSlider.getMaximum() * hanziLookup.getLooseness());
        jSlider.setValue(n);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getMaximum();
                int n2 = jSlider.getValue();
                double d = (double)n2 / (double)n;
                hanziLookup.setLooseness(d);
            }
        });
        return jSlider;
    }

    private static class MacroKeyListener
    implements KeyListener {
        private JTextField lookupField;
        private JTextField clearField;
        private JTextField undoField;
        private HanziLookup hanziLookup;

        private MacroKeyListener(JTextField jTextField, JTextField jTextField2, JTextField jTextField3, HanziLookup hanziLookup) {
            this.lookupField = jTextField;
            this.clearField = jTextField2;
            this.undoField = jTextField3;
            this.hanziLookup = hanziLookup;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            if (0 != n && !this.isModifier(n)) {
                Object object = keyEvent.getSource();
                String string = HanziLookupUIBuilder.getKeyStrokeText(n, n2);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
                if (object == this.lookupField) {
                    this.hanziLookup.registerLookupMacro(keyStroke);
                    this.lookupField.setText(string);
                } else if (object == this.clearField) {
                    this.hanziLookup.registerClearMacro(keyStroke);
                    this.clearField.setText(string);
                } else {
                    this.hanziLookup.registerUndoMacro(keyStroke);
                    this.undoField.setText(string);
                }
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        private boolean isModifier(int n) {
            return 17 == n || 18 == n || 157 == n || 16 == n;
        }
    }
}

