/*
 * Decompiled with CFR 0.152.
 */
package hanzilookup.ui;

import hanzilookup.data.CharacterDescriptor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WrittenCharacter {
    private double leftX;
    private double rightX;
    private double topY;
    private double bottomY;
    private List strokeList = new ArrayList();

    public WrittenCharacter() {
        this.resetEdges();
    }

    public List getStrokeList() {
        return this.strokeList;
    }

    public void addStroke(WrittenStroke writtenStroke) {
        this.strokeList.add(writtenStroke);
    }

    public void clear() {
        this.strokeList.clear();
        this.resetEdges();
    }

    public void undo() {
        if (this.strokeList.size() > 0) {
            this.strokeList.remove(this.strokeList.size() - 1);
        }
    }

    private void resetEdges() {
        this.leftX = Double.MAX_VALUE;
        this.rightX = Double.MIN_VALUE;
        this.topY = Double.MAX_VALUE;
        this.bottomY = Double.MIN_VALUE;
    }

    public void analyzeAndMark() {
        Iterator iterator = this.strokeList.iterator();
        while (iterator.hasNext()) {
            WrittenStroke writtenStroke = (WrittenStroke)iterator.next();
            if (writtenStroke.isAnalyzed()) continue;
            writtenStroke.analyzeAndMark();
        }
    }

    public CharacterDescriptor buildCharacterDescriptor() {
        int n = this.strokeList.size();
        int n2 = 0;
        CharacterDescriptor characterDescriptor = new CharacterDescriptor();
        double[] dArray = characterDescriptor.getDirections();
        double[] dArray2 = characterDescriptor.getLengths();
        Iterator iterator = this.strokeList.iterator();
        while (iterator.hasNext() && n2 < 64) {
            WrittenStroke writtenStroke = (WrittenStroke)iterator.next();
            List list = writtenStroke.getSubStrokes();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext() && n2 < 64) {
                SubStrokeDescriptor subStrokeDescriptor = (SubStrokeDescriptor)iterator2.next();
                dArray[n2] = subStrokeDescriptor.direction;
                dArray2[n2] = subStrokeDescriptor.length;
                ++n2;
            }
        }
        characterDescriptor.setStrokeCount(n);
        characterDescriptor.setSubStrokeCount(n2);
        return characterDescriptor;
    }

    public static class SubStrokeDescriptor {
        private double direction;
        private double length;

        private SubStrokeDescriptor(double d, double d2) {
            this.direction = d;
            this.length = d2;
        }

        public double getDirection() {
            return this.direction;
        }

        public double getLength() {
            return this.length;
        }
    }

    public class WrittenPoint
    extends Point {
        private int subStrokeIndex;
        private boolean isPivot;

        public WrittenPoint(int n, int n2) {
            super(n, n2);
        }

        public int getSubStrokeIndex() {
            return this.subStrokeIndex;
        }

        private void setSubStrokeIndex(int n) {
            this.subStrokeIndex = n;
        }

        public boolean isPivot() {
            return this.isPivot;
        }

        private void setIsPivot(boolean bl) {
            this.isPivot = bl;
        }

        private double getDistanceNormalized(WrittenPoint writtenPoint) {
            double d;
            double d2 = WrittenCharacter.this.rightX - WrittenCharacter.this.leftX;
            double d3 = d2 > (d = WrittenCharacter.this.bottomY - WrittenCharacter.this.topY) ? d2 * d2 : d * d;
            double d4 = Math.sqrt(d3 + d3);
            double d5 = this.distance(writtenPoint) / d4;
            d5 = Math.min(d5, 1.0);
            return d5;
        }

        private double getDirection(WrittenPoint writtenPoint) {
            double d = this.getX() - writtenPoint.getX();
            double d2 = this.getY() - writtenPoint.getY();
            double d3 = Math.PI - Math.atan2(d2, d);
            return d3;
        }
    }

    public class WrittenStroke {
        private List pointList = new ArrayList();
        private boolean isAnalyzed = false;
        private static final double MIN_SEGMENT_LENGTH = 12.5;
        private static final double MAX_LOCAL_LENGTH_RATIO = 1.1;
        private static final double MAX_RUNNING_LENGTH_RATIO = 1.09;

        public List getPointList() {
            return this.pointList;
        }

        public boolean isAnalyzed() {
            return this.isAnalyzed;
        }

        public void addPoint(WrittenPoint writtenPoint) {
            int n = (int)writtenPoint.getX();
            int n2 = (int)writtenPoint.getY();
            WrittenCharacter.this.leftX = Math.min((double)n, WrittenCharacter.this.leftX);
            WrittenCharacter.this.rightX = Math.max((double)n, WrittenCharacter.this.rightX);
            WrittenCharacter.this.topY = Math.min((double)n2, WrittenCharacter.this.topY);
            WrittenCharacter.this.bottomY = Math.max((double)n2, WrittenCharacter.this.bottomY);
            this.pointList.add(writtenPoint);
        }

        public List getSubStrokes() {
            if (!this.isAnalyzed) {
                this.analyzeAndMark();
            }
            ArrayList<SubStrokeDescriptor> arrayList = new ArrayList<SubStrokeDescriptor>();
            Iterator iterator = this.pointList.iterator();
            WrittenPoint writtenPoint = (WrittenPoint)iterator.next();
            while (iterator.hasNext()) {
                WrittenPoint writtenPoint2 = (WrittenPoint)iterator.next();
                if (!writtenPoint2.isPivot()) continue;
                double d = writtenPoint.getDirection(writtenPoint2);
                double d2 = writtenPoint.getDistanceNormalized(writtenPoint2);
                SubStrokeDescriptor subStrokeDescriptor = new SubStrokeDescriptor(d, d2);
                arrayList.add(subStrokeDescriptor);
                writtenPoint = writtenPoint2;
            }
            return arrayList;
        }

        private void analyzeAndMark() {
            double d;
            WrittenPoint writtenPoint;
            Iterator iterator = this.pointList.iterator();
            WrittenPoint writtenPoint2 = writtenPoint = (WrittenPoint)iterator.next();
            WrittenPoint writtenPoint3 = (WrittenPoint)iterator.next();
            writtenPoint.setIsPivot(true);
            int n = 1;
            writtenPoint.setSubStrokeIndex(n);
            writtenPoint3.setSubStrokeIndex(n);
            double d2 = d = writtenPoint.distance(writtenPoint3);
            while (iterator.hasNext()) {
                WrittenPoint writtenPoint4 = (WrittenPoint)iterator.next();
                double d3 = writtenPoint3.distance(writtenPoint4);
                d2 += d3;
                if ((d += d3) >= 1.1 * writtenPoint2.distance(writtenPoint4) || d2 >= 1.09 * writtenPoint.distance(writtenPoint4)) {
                    if (writtenPoint2.isPivot() && writtenPoint2.distance(writtenPoint3) < 12.5) {
                        writtenPoint2.setIsPivot(false);
                        writtenPoint2.setSubStrokeIndex(n - 1);
                    } else {
                        ++n;
                    }
                    writtenPoint3.setIsPivot(true);
                    d2 = d3;
                    writtenPoint = writtenPoint3;
                }
                d = d3;
                writtenPoint2 = writtenPoint3;
                writtenPoint3 = writtenPoint4;
                writtenPoint3.setSubStrokeIndex(n);
            }
            writtenPoint3.setIsPivot(true);
            if (writtenPoint2.isPivot() && writtenPoint2.distance(writtenPoint3) < 12.5 && writtenPoint2 != this.pointList.get(0)) {
                writtenPoint2.setIsPivot(false);
                writtenPoint3.setSubStrokeIndex(n - 1);
            }
            this.isAnalyzed = true;
        }
    }
}

