/*
 * Decompiled with CFR 0.152.
 */
package kiang.awt.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public class CurveUtils {
    public static Point2D getPointOnQuadCurve(QuadCurve2D quadCurve2D, double d) {
        if (null == quadCurve2D) {
            throw new NullPointerException("curve must be non-null!");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("t must be between 0 and 1!");
        }
        double d2 = CurveUtils.getQuadAx(quadCurve2D);
        double d3 = CurveUtils.getQuadBx(quadCurve2D);
        double d4 = CurveUtils.getQuadAy(quadCurve2D);
        double d5 = CurveUtils.getQuadBy(quadCurve2D);
        double d6 = d * d;
        double d7 = d2 * d6 + d3 * d + quadCurve2D.getX1();
        double d8 = d4 * d6 + d5 * d + quadCurve2D.getY1();
        return new Point2D.Double(d7, d8);
    }

    public static int solveQuadCurveForX(QuadCurve2D quadCurve2D, double d, double[] dArray) {
        double d2 = CurveUtils.getQuadAx(quadCurve2D);
        double d3 = CurveUtils.getQuadBx(quadCurve2D);
        double d4 = quadCurve2D.getX1() - d;
        double[] dArray2 = new double[]{d4, d3, d2};
        int n = QuadCurve2D.solveQuadratic(dArray2);
        return CurveUtils.copyValidSolutions(n, dArray2, dArray);
    }

    public static int solveQuadCurveForY(QuadCurve2D quadCurve2D, double d, double[] dArray) {
        double d2 = CurveUtils.getQuadAy(quadCurve2D);
        double d3 = CurveUtils.getQuadBy(quadCurve2D);
        double d4 = quadCurve2D.getY1() - d;
        double[] dArray2 = new double[]{d4, d3, d2};
        int n = QuadCurve2D.solveQuadratic(dArray2, dArray);
        return CurveUtils.copyValidSolutions(n, dArray2, dArray);
    }

    private static double getQuadAx(QuadCurve2D quadCurve2D) {
        return quadCurve2D.getX1() - 2.0 * quadCurve2D.getCtrlX() + quadCurve2D.getX2();
    }

    private static double getQuadBx(QuadCurve2D quadCurve2D) {
        return 2.0 * (-quadCurve2D.getX1() + quadCurve2D.getCtrlX());
    }

    private static double getQuadAy(QuadCurve2D quadCurve2D) {
        return quadCurve2D.getY1() - 2.0 * quadCurve2D.getCtrlY() + quadCurve2D.getY2();
    }

    private static double getQuadBy(QuadCurve2D quadCurve2D) {
        return 2.0 * (-quadCurve2D.getY1() + quadCurve2D.getCtrlY());
    }

    public static Point2D getPointOnCubicCurve(CubicCurve2D cubicCurve2D, double d) {
        if (null == cubicCurve2D) {
            throw new NullPointerException("curve must be non-null!");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("t must be between 0 and 1!");
        }
        double d2 = CurveUtils.getCubicAx(cubicCurve2D);
        double d3 = CurveUtils.getCubicBx(cubicCurve2D);
        double d4 = CurveUtils.getCubicCx(cubicCurve2D);
        double d5 = CurveUtils.getCubicAy(cubicCurve2D);
        double d6 = CurveUtils.getCubicBy(cubicCurve2D);
        double d7 = CurveUtils.getCubicCy(cubicCurve2D);
        double d8 = d * d;
        double d9 = d * d8;
        double d10 = d2 * d9 + d3 * d8 + d4 * d + cubicCurve2D.getX1();
        double d11 = d5 * d9 + d6 * d8 + d7 * d + cubicCurve2D.getY1();
        return new Point2D.Double(d10, d11);
    }

    public static int solveCubicCurveForX(CubicCurve2D cubicCurve2D, double d, double[] dArray) {
        double d2 = CurveUtils.getCubicAx(cubicCurve2D);
        double d3 = CurveUtils.getCubicBx(cubicCurve2D);
        double d4 = CurveUtils.getCubicCx(cubicCurve2D);
        double d5 = cubicCurve2D.getX1() - d;
        double[] dArray2 = new double[]{d5, d4, d3, d2};
        int n = CubicCurve2D.solveCubic(dArray2);
        return CurveUtils.copyValidSolutions(n, dArray2, dArray);
    }

    public static int solveCubicCurveForY(CubicCurve2D cubicCurve2D, double d, double[] dArray) {
        double d2 = CurveUtils.getCubicAy(cubicCurve2D);
        double d3 = CurveUtils.getCubicBy(cubicCurve2D);
        double d4 = CurveUtils.getCubicCy(cubicCurve2D);
        double d5 = cubicCurve2D.getY1() - d;
        double[] dArray2 = new double[]{d5, d4, d3, d2};
        int n = CubicCurve2D.solveCubic(dArray2);
        return CurveUtils.copyValidSolutions(n, dArray2, dArray);
    }

    private static double getCubicAx(CubicCurve2D cubicCurve2D) {
        return cubicCurve2D.getX2() - cubicCurve2D.getX1() - CurveUtils.getCubicBx(cubicCurve2D) - CurveUtils.getCubicCx(cubicCurve2D);
    }

    private static double getCubicAy(CubicCurve2D cubicCurve2D) {
        return cubicCurve2D.getY2() - cubicCurve2D.getY1() - CurveUtils.getCubicBy(cubicCurve2D) - CurveUtils.getCubicCy(cubicCurve2D);
    }

    private static double getCubicBx(CubicCurve2D cubicCurve2D) {
        return 3.0 * (cubicCurve2D.getCtrlX2() - cubicCurve2D.getCtrlX1()) - CurveUtils.getCubicCx(cubicCurve2D);
    }

    private static double getCubicBy(CubicCurve2D cubicCurve2D) {
        return 3.0 * (cubicCurve2D.getCtrlY2() - cubicCurve2D.getCtrlY1()) - CurveUtils.getCubicCy(cubicCurve2D);
    }

    private static double getCubicCx(CubicCurve2D cubicCurve2D) {
        return 3.0 * (cubicCurve2D.getCtrlX1() - cubicCurve2D.getX1());
    }

    private static double getCubicCy(CubicCurve2D cubicCurve2D) {
        return 3.0 * (cubicCurve2D.getCtrlY1() - cubicCurve2D.getY1());
    }

    private static int copyValidSolutions(int n, double[] dArray, double[] dArray2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] >= 0.0) || !(dArray[i] <= 1.0)) continue;
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                if (dArray[i] != dArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (n2 < dArray2.length) {
                dArray2[n2] = dArray[i];
            }
            ++n2;
        }
        return n2;
    }

    public static double quadCurveLength(QuadCurve2D quadCurve2D, double d) {
        if (null == quadCurve2D) {
            throw new NullPointerException("curve must be non-null!");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("flatness must be greater than 0!");
        }
        if (quadCurve2D.getFlatness() > d) {
            QuadCurve2D.Double double_ = new QuadCurve2D.Double();
            QuadCurve2D.Double double_2 = new QuadCurve2D.Double();
            quadCurve2D.subdivide(double_, double_2);
            return CurveUtils.quadCurveLength(double_, d) + CurveUtils.quadCurveLength(double_2, d);
        }
        return Point2D.distance(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getX2(), quadCurve2D.getY2());
    }

    public static double cubicCurveLength(CubicCurve2D cubicCurve2D, double d) {
        if (null == cubicCurve2D) {
            throw new NullPointerException("curve must be non-null!");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("flatness must be greater than 0!");
        }
        if (cubicCurve2D.getFlatness() > d) {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            cubicCurve2D.subdivide(double_, double_2);
            return CurveUtils.cubicCurveLength(double_, d) + CurveUtils.cubicCurveLength(double_2, d);
        }
        return Point2D.distance(cubicCurve2D.getX1(), cubicCurve2D.getY1(), cubicCurve2D.getX2(), cubicCurve2D.getY2());
    }
}

