/*
 * Decompiled with CFR 0.152.
 */
package kiang.chinese.font;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import kiang.chinese.font.ChineseFontFinder;
import kiang.swing.JFontChooser;

public class ChineseFontChooserFactory {
    public static Font showDialog(Component component) {
        Font font = component.getFont();
        String string = "\u6c49  \u6f22";
        int[] nArray = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        return ChineseFontChooserFactory.showDialog(component, font, fontArray, nArray, string);
    }

    public static Font showDialog(Component component, Font font, Font[] fontArray, int[] nArray, String string) {
        JFontChooser.FontFilter[] fontFilterArray = ChineseFontChooserFactory.getChineseFilters(font);
        return JFontChooser.showDialog(component, font, fontArray, nArray, fontFilterArray, string);
    }

    static JFontChooser getInstance(Font font, Font[] fontArray, int[] nArray, String string) {
        JFontChooser.FontFilter[] fontFilterArray = ChineseFontChooserFactory.getChineseFilters(font);
        return new JFontChooser(font, fontArray, nArray, fontFilterArray, string);
    }

    private static JFontChooser.FontFilter[] getChineseFilters(Font font) {
        return new JFontChooser.FontFilter[]{new SimplifiedFontFilter(font), new TraditionalFontFilter(font)};
    }

    private static class TraditionalFontFilter
    implements JFontChooser.FontFilter {
        private Font initialFont;

        private TraditionalFontFilter(Font font) {
            this.initialFont = font;
        }

        public String getDisplayName() {
            return "Traditional";
        }

        public boolean isDefaultOn() {
            return this.shouldInclude(this.initialFont);
        }

        public boolean shouldInclude(Font font) {
            return ChineseFontFinder.isTraditionalFont(font);
        }
    }

    private static class SimplifiedFontFilter
    implements JFontChooser.FontFilter {
        private Font initialFont;

        private SimplifiedFontFilter(Font font) {
            this.initialFont = font;
        }

        public String getDisplayName() {
            return "Simplified";
        }

        public boolean isDefaultOn() {
            return this.shouldInclude(this.initialFont);
        }

        public boolean shouldInclude(Font font) {
            return ChineseFontFinder.isSimplifiedFont(font);
        }
    }
}

