/*
 * Decompiled with CFR 0.152.
 */
package kiang.chinese.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;

public class ChineseFontFinder {
    private static final String[] PREFERRED_FONTS = new String[]{"SimSun", "STHeiti", "Bitstream Cyberbit"};
    private static final String SIMPLIFIED_CHARACTERS = "\u8fd9\u6765\u56fd\u4e2a\u6c49";
    private static final String TRADITIONAL_CHARACTERS = "\u9019\u4f86\u570b\u500b\u6f22";
    private static final int FONT_SIZE = 24;

    public static Font getChineseFont() {
        Font font = null;
        boolean bl = false;
        boolean bl2 = false;
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            Font font2 = fontArray[i];
            boolean bl3 = false;
            boolean bl4 = ChineseFontFinder.isSimplifiedFont(font2);
            boolean bl5 = ChineseFontFinder.isTraditionalFont(font2);
            if (ChineseFontFinder.isPreferredFont(font2)) {
                font = font2;
                break;
            }
            if (null == font) {
                if (bl4 || bl5) {
                    bl3 = true;
                }
            } else if (bl5 && bl4 && (!bl2 || !bl)) {
                bl3 = true;
            }
            if (!bl3) continue;
            font = font2;
            bl = bl4;
            bl2 = bl5;
        }
        if (null != font) {
            font = font.deriveFont(0, 24.0f);
        }
        return font;
    }

    public static Font[] getAllChineseFonts() {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (int i = 0; i < fontArray.length; ++i) {
            if (!ChineseFontFinder.isTraditionalFont(fontArray[i]) && !ChineseFontFinder.isSimplifiedFont(fontArray[i])) continue;
            arrayList.add(fontArray[i]);
        }
        Font[] fontArray2 = new Font[arrayList.size()];
        return arrayList.toArray(fontArray2);
    }

    public static boolean isSimplifiedFont(Font font) {
        return -1 == font.canDisplayUpTo(SIMPLIFIED_CHARACTERS);
    }

    public static boolean isTraditionalFont(Font font) {
        return -1 == font.canDisplayUpTo(TRADITIONAL_CHARACTERS);
    }

    private static boolean isPreferredFont(Font font) {
        for (int i = 0; i < PREFERRED_FONTS.length; ++i) {
            if (!PREFERRED_FONTS[i].equals(font.getFontName()) || !ChineseFontFinder.isSimplifiedFont(font) || !ChineseFontFinder.isTraditionalFont(font)) continue;
            return true;
        }
        return false;
    }
}

