/*
 * Decompiled with CFR 0.152.
 */
package kiang.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public abstract class LineParser {
    public final void parse(InputStream inputStream) throws IOException {
        this.parse(inputStream, Charset.forName("US-ASCII"));
    }

    public final void parse(InputStream inputStream, Charset charset) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        int n = 0;
        String string = bufferedReader.readLine();
        while (null != string) {
            if (this.shouldParseLine(n, string) && !this.parseLine(n, string)) {
                this.lineError(n, string);
            }
            ++n;
            string = bufferedReader.readLine();
        }
        inputStream.close();
    }

    protected abstract boolean parseLine(int var1, String var2);

    protected void lineError(int n, String string) {
        System.err.println("Error parsing line " + n + ": " + string);
    }

    protected boolean shouldParseLine(int n, String string) {
        return !this.isLineEmpty(string) && !this.isLineComment(string);
    }

    protected boolean isLineComment(String string) {
        return string.matches("^\\s*//.*") || string.matches("^\\s*#.*");
    }

    protected boolean isLineEmpty(String string) {
        return string.matches("^\\s*$");
    }
}

