/*
 * Decompiled with CFR 0.152.
 */
package kiang.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JList;

public class JClickableList
extends JList {
    private Set listClickedListeners = new LinkedHashSet();

    public JClickableList() {
        this.initEventListeners();
    }

    private void initEventListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = JClickableList.this.locationToIndex(mouseEvent.getPoint());
                if (n > -1 && JClickableList.this.isSelectedIndex(n)) {
                    JClickableList.this.notifyClickListeners();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (10 == keyEvent.getKeyCode() && (n = JClickableList.this.getSelectedIndex()) > -1) {
                    JClickableList.this.notifyClickListeners();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClickListeners() {
        Set set = this.listClickedListeners;
        synchronized (set) {
            Iterator iterator = this.listClickedListeners.iterator();
            while (iterator.hasNext()) {
                ListClickedListener listClickedListener = (ListClickedListener)iterator.next();
                listClickedListener.listClicked(new ListClickedEvent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListClickedListener(ListClickedListener listClickedListener) {
        if (null != listClickedListener) {
            Set set = this.listClickedListeners;
            synchronized (set) {
                this.listClickedListeners.add(listClickedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListClickedListener(ListClickedListener listClickedListener) {
        if (null != listClickedListener) {
            Set set = this.listClickedListeners;
            synchronized (set) {
                this.listClickedListeners.remove(listClickedListener);
            }
        }
    }

    public static interface ListClickedListener {
        public void listClicked(ListClickedEvent var1);
    }

    public class ListClickedEvent
    extends EventObject {
        private ListClickedEvent() {
            super(JClickableList.this);
        }
    }
}

