/*
 * Decompiled with CFR 0.152.
 */
package kiang.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kiang.swing.JTextListLink;

public class JFontChooser
extends JComponent {
    private JTextField fontChooserField;
    private JList fontChooserList;
    private JTextListLink fontChooserLink;
    private JTextField sizeChooserField;
    private JList sizeChooserList;
    private JTextListLink sizeChooserLink;
    private JCheckBox boldCheckBox;
    private JCheckBox italicCheckBox;
    private JLabel previewLabel;
    private Font[] fontOptions;
    private Set appliedFilters;

    public static Font showDialog(Component component) {
        Font font = component.getFont();
        String string = "The quick brown fox jumps over the lazy dog.  123456790";
        int[] nArray = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        return JFontChooser.showDialog(component, font, fontArray, nArray, new FontFilter[0], string);
    }

    public static Font showDialog(Component component, Font font, Font[] fontArray, int[] nArray, FontFilter[] fontFilterArray, String string) {
        JFontChooser jFontChooser;
        JFontChooser jFontChooser2 = jFontChooser = new JFontChooser(font, fontArray, nArray, fontFilterArray, string);
        jFontChooser2.getClass();
        FontReturner fontReturner = jFontChooser2.new FontReturner();
        FontChooserDialog fontChooserDialog = new FontChooserDialog(component, "Choose a Font", true, jFontChooser, fontReturner, null);
        fontChooserDialog.setLocation(component.getLocationOnScreen());
        fontChooserDialog.pack();
        fontChooserDialog.setVisible(true);
        return fontReturner.getFont();
    }

    public JFontChooser(Font font, Font[] fontArray, int[] nArray, FontFilter[] fontFilterArray, String string) {
        this.init(font, fontArray, nArray, fontFilterArray, string);
    }

    private void init(Font font, Font[] fontArray, int[] nArray, FontFilter[] fontFilterArray, String string) {
        this.fontOptions = fontArray;
        JComponent jComponent = this.buildOptionsPanel(font, fontArray, nArray, fontFilterArray);
        JComponent jComponent2 = this.buildPreviewPanel(font, string);
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "Center");
        this.add((Component)jComponent2, "South");
    }

    public Font getSelectedFont() {
        Font font = null;
        String string = (String)this.fontChooserList.getSelectedValue();
        if (null != string) {
            int n = 0;
            n |= this.boldCheckBox.isSelected() ? 1 : 0;
            n |= this.italicCheckBox.isSelected() ? 2 : 0;
            int n2 = -1;
            try {
                n2 = Integer.parseInt(this.sizeChooserField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0) {
                n2 = this.previewLabel.getFont().getSize();
            }
            font = new Font(string, n, n2);
        }
        return font;
    }

    private JComponent buildOptionsPanel(Font font, Font[] fontArray, int[] nArray, FontFilter[] fontFilterArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JComponent jComponent = this.buildFontChooserPanel(font, fontArray);
        JComponent jComponent2 = this.buildSizeChooserPanel(font, nArray);
        JComponent jComponent3 = this.buildStyleChooserPanel(font);
        jPanel.add(jComponent);
        jPanel.add(jComponent2);
        jPanel.add(jComponent3);
        JPanel jPanel2 = null;
        if (fontFilterArray.length > 0) {
            JComponent jComponent4 = this.buildFilterChooser(fontFilterArray);
            jComponent4.setBorder(BorderFactory.createTitledBorder("Filters"));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jComponent4, "South");
            jPanel2 = jPanel3;
        } else {
            jPanel2 = jPanel;
        }
        this.loadFilteredFonts(font);
        this.setupFontSelectionListener();
        return jPanel2;
    }

    private void setupFontSelectionListener() {
        FontSelectionListener fontSelectionListener = new FontSelectionListener();
        this.fontChooserField.getDocument().addDocumentListener(fontSelectionListener);
        this.fontChooserList.addListSelectionListener(fontSelectionListener);
        this.sizeChooserField.getDocument().addDocumentListener(fontSelectionListener);
        this.sizeChooserList.addListSelectionListener(fontSelectionListener);
        this.boldCheckBox.addActionListener(fontSelectionListener);
        this.italicCheckBox.addActionListener(fontSelectionListener);
    }

    private JComponent buildFontChooserPanel(Font font, Font[] fontArray) {
        this.fontChooserField = new JTextField(font.getName());
        JComponent jComponent = this.buildFontChooserListPane();
        this.fontChooserLink = new JTextListLink(this.fontChooserField, this.fontChooserList, true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.fontChooserField, "North");
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        return jPanel;
    }

    private JComponent buildFontChooserListPane() {
        this.fontChooserList = new JList();
        this.fontChooserList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.fontChooserList, 22, 30);
        return jScrollPane;
    }

    private void loadFilteredFonts(Font font) {
        Iterator iterator;
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (int i = 0; i < this.fontOptions.length; ++i) {
            boolean bl = true;
            iterator = this.appliedFilters.iterator();
            while (iterator.hasNext()) {
                FontFilter fontFilter = (FontFilter)iterator.next();
                if (fontFilter.shouldInclude(this.fontOptions[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(this.fontOptions[i]);
        }
        String string = null != font ? font.getName() : null;
        String[] stringArray = new String[arrayList.size()];
        iterator = arrayList.iterator();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            Font font2 = (Font)iterator.next();
            stringArray[n] = font2.getName();
            if (stringArray[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
        this.fontChooserList.setListData(stringArray);
        if (bl) {
            this.fontChooserList.setSelectedValue(string, true);
        } else {
            this.fontChooserField.setText("");
        }
    }

    private JComponent buildSizeChooserPanel(Font font, int[] nArray) {
        int n = font.getSize();
        this.sizeChooserField = new JTextField(Integer.toString(n));
        JComponent jComponent = this.buildSizeChooserList(n, nArray);
        this.sizeChooserLink = new JTextListLink(this.sizeChooserField, this.sizeChooserList, true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.sizeChooserField, "North");
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Size"));
        return jPanel;
    }

    private JComponent buildSizeChooserList(int n, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = Integer.toString(nArray[i]);
        }
        this.sizeChooserList = new JList<String>(stringArray);
        this.sizeChooserList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.sizeChooserList, 22, 30);
        return jScrollPane;
    }

    private JComponent buildStyleChooserPanel(Font font) {
        this.boldCheckBox = new JCheckBox("Bold", font.isBold());
        this.italicCheckBox = new JCheckBox("Italics", font.isItalic());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.boldCheckBox);
        jPanel.add(this.italicCheckBox);
        jPanel.setBorder(BorderFactory.createTitledBorder("Style"));
        return jPanel;
    }

    private JComponent buildFilterChooser(FontFilter[] fontFilterArray) {
        this.appliedFilters = new HashSet();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        for (int i = 0; i < fontFilterArray.length; ++i) {
            if (fontFilterArray[i].isDefaultOn()) {
                this.appliedFilters.add(fontFilterArray[i]);
            }
            JCheckBox jCheckBox = this.buildFilterCheckBox(fontFilterArray[i]);
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    private JCheckBox buildFilterCheckBox(final FontFilter fontFilter) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    JFontChooser.this.appliedFilters.add(fontFilter);
                } else {
                    JFontChooser.this.appliedFilters.remove(fontFilter);
                }
                JFontChooser.this.loadFilteredFonts(JFontChooser.this.getSelectedFont());
            }
        };
        JCheckBox jCheckBox = new JCheckBox(fontFilter.getDisplayName(), fontFilter.isDefaultOn());
        jCheckBox.addActionListener(actionListener);
        return jCheckBox;
    }

    private JComponent buildPreviewPanel(Font font, String string) {
        this.previewLabel = new JLabel(string);
        this.previewLabel.setFont(font);
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setVerticalAlignment(0);
        this.previewLabel.setBorder(BorderFactory.createTitledBorder("Preview"));
        JScrollPane jScrollPane = new JScrollPane(this.previewLabel, 20, 30);
        return jScrollPane;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        Font font = new Font("Simsun", 0, 36);
        int[] nArray = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
        String string = "\u6c49  \u6f22";
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (int i = 0; i < fontArray.length; ++i) {
            if (!fontArray[i].canDisplay('\u6c49') && !fontArray[i].canDisplay('\u6f22')) continue;
            arrayList.add(fontArray[i]);
        }
        Font[] fontArray2 = new Font[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fontArray2[n] = (Font)iterator.next();
            ++n;
        }
        FontFilter fontFilter = new FontFilter(){

            public boolean isDefaultOn() {
                return true;
            }

            public boolean shouldInclude(Font font) {
                return font.canDisplay('\u1000');
            }

            public String getDisplayName() {
                return "Test1";
            }
        };
        FontFilter fontFilter2 = new FontFilter(){

            public boolean isDefaultOn() {
                return false;
            }

            public boolean shouldInclude(Font font) {
                return font.canDisplay('\u6f22');
            }

            public String getDisplayName() {
                return "Test2";
            }
        };
        font = JFontChooser.showDialog(jFrame, font, fontArray, nArray, new FontFilter[]{fontFilter, fontFilter2}, string);
    }

    public static interface FontFilter {
        public String getDisplayName();

        public boolean isDefaultOn();

        public boolean shouldInclude(Font var1);
    }

    private class FontReturner
    implements ActionListener {
        private Font font;

        private FontReturner() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.font = JFontChooser.this.getSelectedFont();
        }

        public Font getFont() {
            return this.font;
        }
    }

    private static class FontChooserDialog
    extends JDialog {
        private FontChooserDialog(Component component, String string, boolean bl, JFontChooser jFontChooser, ActionListener actionListener, ActionListener actionListener2) {
            super(JOptionPane.getFrameForComponent(component), string, bl);
            JButton jButton = new JButton("OK");
            JButton jButton2 = new JButton("Cancel");
            ActionListener actionListener3 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontChooserDialog.this.setVisible(false);
                }
            };
            jButton.addActionListener(actionListener3);
            jButton2.addActionListener(actionListener3);
            if (null != actionListener) {
                jButton.addActionListener(actionListener);
            }
            if (null != actionListener2) {
                jButton2.addActionListener(actionListener2);
            }
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(jButton);
            jPanel.add(jButton2);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jFontChooser, "Center");
            container.add((Component)jPanel, "South");
        }
    }

    private class FontSelectionListener
    implements DocumentListener,
    ListSelectionListener,
    ActionListener {
        private FontSelectionListener() {
        }

        public void updatePreviewFont() {
            JFontChooser.this.previewLabel.setFont(JFontChooser.this.getSelectedFont());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updatePreviewFont();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updatePreviewFont();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updatePreviewFont();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updatePreviewFont();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updatePreviewFont();
        }
    }
}

