/*
 * Decompiled with CFR 0.152.
 */
package kiang.swing;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JTextListLink {
    private JTextField textField;
    private JList list;

    public JTextListLink(JTextField jTextField, JList jList, boolean bl) {
        this.textField = jTextField;
        this.list = jList;
        UpdateListener updateListener = new UpdateListener();
        if (bl) {
            updateListener.matchListToText();
        } else {
            updateListener.matchTextToList();
        }
        this.textField.getDocument().addDocumentListener(updateListener);
        this.list.addListSelectionListener(updateListener);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        String[] stringArray2 = new String[]{"america", "aardvark", "abate", "alabaster", "asynchronous", "amen", "alimony", "ack", "acknowledge", "ache", "ape", "antidisestablishmentarianism"};
        JTextField jTextField = new JTextField();
        JList<String> jList = new JList<String>(stringArray2);
        JTextListLink jTextListLink = new JTextListLink(jTextField, jList, true);
        jFrame.getContentPane().add((Component)jTextField, "North");
        jFrame.getContentPane().add(jList, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class UpdateListener
    implements ListSelectionListener,
    DocumentListener {
        private boolean isAdjusting = false;

        private UpdateListener() {
        }

        private synchronized boolean toggleIsAdjustingLock() {
            this.isAdjusting = !this.isAdjusting;
            return this.isAdjusting;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.matchTextToList();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.matchListToText();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.matchListToText();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.matchListToText();
        }

        private int getStringMatchScore(String string, String string2) {
            int n = Math.min(string.length(), string2.length());
            string = string.substring(0, n).toUpperCase();
            string2 = string2.substring(0, n).toUpperCase();
            int n2 = 0;
            for (int i = 0; i < n && string.charAt(i) == string2.charAt(i); ++i) {
                ++n2;
            }
            return n2;
        }

        private boolean matchListToText() {
            if (this.toggleIsAdjustingLock()) {
                String string = JTextListLink.this.textField.getText();
                ListModel listModel = JTextListLink.this.list.getModel();
                int n = listModel.getSize();
                if (n > 0) {
                    int n2 = this.getStringMatchScore(string, listModel.getElementAt(0).toString());
                    int n3 = 0;
                    for (int i = 1; i < n; ++i) {
                        int n4 = this.getStringMatchScore(string, listModel.getElementAt(i).toString());
                        if (n4 <= n2) continue;
                        n2 = n4;
                        n3 = i;
                    }
                    JTextListLink.this.list.setSelectedIndex(n3);
                    JTextListLink.this.list.ensureIndexIsVisible(n3);
                }
                return true;
            }
            return false;
        }

        private boolean matchTextToList() {
            if (this.toggleIsAdjustingLock()) {
                Object e = JTextListLink.this.list.getSelectedValue();
                if (null != e) {
                    JTextListLink.this.textField.setText(e.toString());
                } else {
                    JTextListLink.this.textField.setText("");
                }
                return true;
            }
            return false;
        }
    }
}

