/*
 * Decompiled with CFR 0.152.
 */
package kiang.util;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import kiang.util.ComparableComparator;

public class PriorityList
extends AbstractCollection {
    private LinkedList list = new LinkedList();
    private Comparator comparator;
    private boolean allowsDuplicates;
    private boolean ascendingOrder;

    public PriorityList() {
        this(true, true);
    }

    public PriorityList(Comparator comparator) {
        this(comparator, true, true);
    }

    public PriorityList(boolean bl, boolean bl2) {
        this(new ComparableComparator(), bl, bl2);
    }

    public PriorityList(Comparator comparator, boolean bl, boolean bl2) {
        this.comparator = comparator;
        this.allowsDuplicates = bl;
        this.ascendingOrder = bl2;
    }

    public Comparator getComparator() {
        if (this.comparator instanceof ComparableComparator) {
            return null;
        }
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.resort();
    }

    public boolean getOrder() {
        return this.ascendingOrder;
    }

    public void setOrder(boolean bl) {
        boolean bl2 = this.ascendingOrder;
        this.ascendingOrder = bl;
        if (bl2 != this.ascendingOrder) {
            this.resort();
        }
    }

    private void resort() {
        Collections.sort(this.list, this.comparator);
        if (!this.ascendingOrder) {
            Collections.reverse(this.list);
        }
    }

    public void setAllowsDuplicates(boolean bl) {
        if (this.allowsDuplicates && !bl) {
            this.removeDuplicates();
        }
        this.allowsDuplicates = bl;
    }

    public boolean getAllowsDuplicates() {
        return this.allowsDuplicates;
    }

    private void removeDuplicates() {
        Object object = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (null != object && object.equals(e)) {
                iterator.remove();
            }
            object = e;
        }
    }

    public boolean add(Object object) {
        ListIterator<Object> listIterator = this.list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            int n = this.compare(object, e);
            if (n < 0) {
                listIterator.previous();
                break;
            }
            if (n != 0) continue;
            if (this.allowsDuplicates) break;
            return false;
        }
        listIterator.add(object);
        return true;
    }

    private int compare(Object object, Object object2) {
        int n = this.comparator.compare(object, object2);
        if (this.ascendingOrder && n < 0 || !this.ascendingOrder && n > 0) {
            return -1;
        }
        if (n != 0) {
            return 1;
        }
        return 0;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public Object getFirst() {
        return this.list.getFirst();
    }

    public Object removeFirst() {
        return this.list.removeFirst();
    }

    public Object getLast() {
        return this.list.getLast();
    }

    public Object removeLast() {
        return this.list.removeLast();
    }
}

